clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
all_marks = {'o','+','*','.','x','s','d','^','v','>','<','p','h'};

%% Plot automatico
% Dati
Spessore=200;%um
ps=4; %bar 
x0=[0 10];%um
test=[1];
pa=101325; %Pa
D_foro=8;

for index_x0=1:length(x0)
    x_0=x0(index_x0);
    for index_Test=1:length(test)
        Test=test(index_Test);
        %Caricamento Automatico Dati
        Misura=['load Test_Membrana_f' num2str(D_foro) '_s' num2str(Spessore) '_ps' num2str(ps) '_x' num2str(x_0) '_' num2str(Test)];
        eval(Misura)


        figure(1)
        plot_Q=['plot(P2_f' num2str(D_foro) '_s' num2str(Spessore) '_ps' num2str(ps) '_x' num2str(x_0) '_' num2str(Test) '/(ps*1e5+pa),Q2_f' num2str(D_foro) '_s' num2str(Spessore) '_ps' num2str(ps) '_x' num2str(x_0) '_' num2str(Test) ',''LineStyle'',''none'',''Marker'',all_marks{mod(index_Test,18)}), hold on'];
        eval(plot_Q)
        title('Portata')
        xlabel('$\frac{P}{P_s}$ (-)')
        ylabel('$Q$ ($\frac{l}{min}$) ANR 20 $^\circ$')
        grid on
        legend('Q_{0}','Q_{10}','Q_{30}','Q_{50}','Q_{70}')

        figure(2)
        plot_x2=['plot(P2_f' num2str(D_foro) '_s' num2str(Spessore) '_ps' num2str(ps) '_x' num2str(x_0) '_' num2str(Test) ',x2_f' num2str(D_foro) '_s' num2str(Spessore) '_ps' num2str(ps) '_x' num2str(x_0) '_' num2str(Test) ',''LineStyle'',''none'',''Marker'',all_marks{mod(index_Test,18)}), hold on'];
        eval(plot_x2)
        title('Spostamento')
        xlabel('$p_{rel.}$ (Pa)')
        ylabel('$x_{laser}$ ($\mu m$)')
        grid on
        legend('x_{0}','x_{10}','x_{30}','x_{50}','x_{70}')
    end
end